/*
 * Decompiled with CFR 0.152.
 */
package compasses.expandedstorage.impl.block.entity;

import compasses.expandedstorage.impl.block.OpenableBlock;
import compasses.expandedstorage.impl.block.entity.extendable.ExposedInventoryBlockEntity;
import compasses.expandedstorage.impl.block.entity.extendable.OpenableBlockEntity;
import compasses.expandedstorage.impl.block.strategies.ItemAccess;
import compasses.expandedstorage.impl.block.strategies.Lockable;
import compasses.expandedstorage.impl.inventory.handler.AbstractHandler;
import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.entity.ContainerOpenersCounter;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;

public final class BarrelBlockEntity
extends ExposedInventoryBlockEntity {
    private final ContainerOpenersCounter manager = new ContainerOpenersCounter(){

        protected void m_142292_(Level level, BlockPos pos, BlockState state) {
            BarrelBlockEntity.playSound(level, state, pos, SoundEvents.f_11725_);
            BarrelBlockEntity.updateBlockState(level, state, pos, true);
        }

        protected void m_142289_(Level level, BlockPos pos, BlockState state) {
            BarrelBlockEntity.playSound(level, state, pos, SoundEvents.f_11724_);
            BarrelBlockEntity.updateBlockState(level, state, pos, false);
        }

        protected void m_142148_(Level level, BlockPos pos, BlockState state, int oldCount, int newCount) {
        }

        protected boolean m_142718_(Player player) {
            AbstractHandler handler;
            AbstractContainerMenu abstractContainerMenu = player.f_36096_;
            return abstractContainerMenu instanceof AbstractHandler && (handler = (AbstractHandler)abstractContainerMenu).getInventory() == BarrelBlockEntity.this;
        }
    };

    public BarrelBlockEntity(BlockEntityType<?> type, BlockPos pos, BlockState state, ResourceLocation blockId, Function<OpenableBlockEntity, ItemAccess> access, Supplier<Lockable> lockable) {
        super(type, pos, state, blockId, ((OpenableBlock)state.m_60734_()).getInventoryTitle(), ((OpenableBlock)state.m_60734_()).getSlotCount());
        this.setItemAccess(access.apply(this));
        this.setLockable(lockable.get());
    }

    private static void playSound(Level level, BlockState state, BlockPos pos, SoundEvent sound) {
        Vec3i facingVector = ((Direction)state.m_61143_((Property)BlockStateProperties.f_61372_)).m_122436_();
        double X = (double)pos.m_123341_() + 0.5 + (double)facingVector.m_123341_() / 2.0;
        double Y = (double)pos.m_123342_() + 0.5 + (double)facingVector.m_123342_() / 2.0;
        double Z = (double)pos.m_123343_() + 0.5 + (double)facingVector.m_123343_() / 2.0;
        level.m_6263_(null, X, Y, Z, sound, SoundSource.BLOCKS, 0.5f, level.f_46441_.m_188501_() * 0.1f + 0.9f);
    }

    private static void updateBlockState(Level level, BlockState state, BlockPos pos, boolean open) {
        level.m_7731_(pos, (BlockState)state.m_61124_((Property)BlockStateProperties.f_61446_, (Comparable)Boolean.valueOf(open)), 3);
    }

    public void m_5856_(Player player) {
        if (player.m_5833_()) {
            return;
        }
        this.manager.m_155452_(player, this.m_58904_(), this.m_58899_(), this.m_58900_());
    }

    public void m_5785_(Player player) {
        if (player.m_5833_()) {
            return;
        }
        this.manager.m_155468_(player, this.m_58904_(), this.m_58899_(), this.m_58900_());
    }

    public void updateViewerCount(ServerLevel level, BlockPos pos, BlockState state) {
        this.manager.m_155476_((Level)level, pos, state);
    }
}

